<?php
$db = new PDO(
    "mysql:host=153.92.1.116;port=3308;dbname=br_test_lesson;charset=utf8mb4",
    "admin",
    'Te$t@dm1n',
    [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]
);
$resetSession = function () {session_unset();session_destroy();session_start();};

session_start();

function call($db, $proc, $params = [], $fetch = false) {
    $ph = implode(",", array_fill(0, count($params), "?"));
    $stmt = $db->prepare("CALL $proc($ph)");
    $stmt->execute(array_values($params));
    $res = $fetch ? $stmt->fetchAll() : null;
    do {} while ($stmt->nextRowset());
    return $res;
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $act = $_POST["act"] ?? "";
    $u = trim($_POST["username"] ?? "");
    $p = trim($_POST["password"] ?? "");

    if ($act === "login" && $u && $p) {
        $r = call($db, "a_get_uid", [$u, $p], true);
        if (!empty($r)) {
            $_SESSION["uid"] = $r[0]["id"];
            call($db, "a_session_start", [$r[0]["id"]]);
		}
    }

    if ($act === "register" && $u && $p) {
        try {call($db, "a_create", [$u, $p]);}
		catch (PDOException $e) {echo htmlspecialchars($e->errorInfo[2]);}
    }

    if ($act === "logout" && !empty($_SESSION["uid"])) {
        call($db, "a_session_end", [$_SESSION["uid"]]);
        $resetSession();
    }

    if ($act === "delete_profile" && !empty($_SESSION["uid"])) {
        call($db, "a_delete", [$_SESSION["uid"]]);
        $resetSession();
    }

    if ($act === "update_profile" && !empty($_SESSION["uid"]) && $u && $p) {
        try {call($db, "a_update", [$_SESSION["uid"], $u, $p]);} 
		catch (PDOException $e) {echo htmlspecialchars($e->errorInfo[2]);}
    }

    if ($act === "do_action" && !empty($_SESSION["uid"])) {
        call($db, "a_session_start", [$_SESSION["uid"]]);
    }
}

$logged = false;
$display = "Viesis";
if (!empty($_SESSION["uid"])) {
    $stmt = $db->prepare("SELECT active,name FROM aaa WHERE id=?");
    $stmt->execute([$_SESSION["uid"]]);
    $r = $stmt->fetch();
    if ($r["active"] == 1) {$logged = true; $display = $r["name"];} else {$resetSession();}
}
?>
<!doctype html>
<html>
<body>
<p>Status: <?php echo htmlspecialchars($display) . " " . ($logged ? "pieslēdzies" : "nav pieslēdzies"); ?></p>

<?php if (!$logged): ?>
    <button onclick="toggle('login')">Pieslēgties</button>
    <div id="login" style="display:none; margin-top:10px;">
        <form method="post">
            <input type="hidden" name="act" value="login">
            <input name="username" placeholder="Lietotājvārds" required>
            <input type="password" name="password" placeholder="Parole" required>
            <button type="submit">Login</button>
            <button type="button" onclick="toggle('login')">Atcelt</button>
        </form>
    </div>

    <button onclick="toggle('reg')">Reģistrēties</button>
    <div id="reg" style="display:none; margin-top:10px;">
        <form method="post">
            <input type="hidden" name="act" value="register">
            <input name="username" placeholder="Lietotājvārds" required>
            <input type="password" name="password" placeholder="Parole" required>
            <button type="submit">Register</button>
            <button type="button" onclick="toggle('reg')">Atcelt</button>
        </form>
    </div>

<?php else: ?>
    <form method="post" style="display:inline">
        <input type="hidden" name="act" value="logout">
        <button type="submit">Iziet</button>
    </form>

    <form method="post" style="display:inline">
        <input type="hidden" name="act" value="do_action">
        <button type="submit">Darbība</button>
    </form>

    <form method="post" style="display:inline" onsubmit="return confirm('Vai tiešām dzēst profilu?');">
        <input type="hidden" name="act" value="delete_profile">
        <button type="submit">Dzēst profilu</button>
    </form>

    <button onclick="toggle('update')">Labot profilu</button>
    <div id="update" style="display:none; margin-top:10px;">
        <form method="post">
            <input type="hidden" name="act" value="update_profile">
            <input name="username" placeholder="Jauns lietotājvārds" required>
            <input type="password" name="password" placeholder="Jauna parole" required>
            <button type="submit">Saglabāt izmaiņas</button>
            <button type="button" onclick="toggle('update')">Atcelt</button>
        </form>
    </div>
<?php endif; ?>

<script>
function toggle(id){var e = document.getElementById(id);e.style.display = e.style.display === 'block' ? 'none' : 'block';}
</script>
</body>
</html>
